/*******************************************************
Filename		:  FA_REGULAR_RESULT_data2.sql
Release 		:  c2.0
SIR			:  1497
Description		:  Adds additional data element to the FA_REGULAR_RESULT fact table.
Author			:  Joseph Wilson/Ganesh Thadkamalla
Date			:  3/28/2003
			   4/2003 - Edited to replace some org_id columns with organization_id --GAnesh.
			   7-01-2003 --changed names from CHEM to REGULAR; added new 2.0 columns and removed outdated -JW
			   7-03-2003 --updated dates to single date/time values -JW
			   7-10-2003 --added units to detection_limit -JW
			   7-15-2003 --added SAMPLE_FRACTION_TYPE -JW
			   7-16-2003 --added CAS # and ITIS # -JW
			   7-21-2003 --added new sample pres elements; changed name to SGO indicator -JW
			   7-29-2003 --added EPA REG # -JW
			   8-04-2003 --updated result comment and text result to user long_temp table; updated field_set -JW
			   8-11-2003 --updated SAMPLE PRES ELEMENTS update -JW
                     8-13-2003 --added logic to set activity attributes for 'Composite-with Parents' samples. -C Tsang
Comments		:  new version of this script that uses seperate update statements at the table level.  This was done to reduce the number of update statements to improve performance time.  
**********************************************************/
spool FA_REGULAR_RESULT_data2.log
--remove sublogs after IT

connect storetw/storetw@storet.sdc
set serveroutput on
set time on

SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
--CHAR (RE-WRITE TO USE DI_CHARACTERISTIC TABLE)
UPDATE FA_REGULAR_RESULT RE SET CHARACTERISTIC_NAME =
	(SELECT CHR.DISPLAY_NAME	
	FROM storet.TSRCHAR CHR
	WHERE re.FK_CHAR = CHR.TSRCHAR_IS_NUMBER
	AND re.TSRCHAR_ORG_ID = CHR.TSRCHAR_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--PARTICLE SIZE
UPDATE FA_REGULAR_RESULT RE SET PARTICLE_SIZE =
	(SELECT RCI.PARTICLE_SIZE_BASIS
	FROM storet1.TSRRCI RCI
	WHERE re.result_is_number = RCI.TSRRSULT_IS_NUMBER
	AND re.ORGANIZATION_ID = RCI.TSRRSULT_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--trip and station visit info
UPDATE FA_REGULAR_RESULT RE 
SET (STATION_ID,STATION_NAME,TRIP_ID,TRIP_NAME,STATION_VISIT_ID,TSMSTATN_IS_NUMBER,
     VISIT_START_DATE_TIME,VISIT_START_TIME_ZONE,VISIT_STOP_DATE_TIME,VISIT_STOP_TIME_ZONE) =
(SELECT st.STATION_ID,st.STATION_NAME,st.TRIP_ID,st.TRIP_NAME,st.STATION_VISIT_ID,st.TSMSTATN_IS_NUMBER,
	st.VISIT_START_DATE_TIME,st.VISIT_START_TIME_ZONE,st.VISIT_STOP_DATE_TIME,st.VISIT_STOP_TIME_ZONE	
  	from statninfo_temp st
  	WHERE re.TSRSTVST_IS_NUMBER = ST.TSRSTVST_IS_NUMBER
	AND re.ORGANIZATION_ID = ST.TSRSTVST_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

spool fa_reg_data2_1a
--STATION and STATION LOCATION INFO
update FA_REGULAR_RESULT re set (fk_station,
		re.fk_org, 
		re.fk_db_cat,
		re.fk_geo_county,
		re.fk_geo_state,
		re.fk_mad_hdatum,
		re.fk_mad_hmethod,
		re.stn_latitude,
		re.stn_longitude,
		re.hydrologic_unit_code,
		re.sgo_indicator)=
	(select st.pk_isn,
		st.fk_org,
		st.fk_db_cat,
		st.fk_geo_county,
		st.fk_geo_state,
		st.fk_mad_hdatum,
		st.fk_mad_hmethod,
		st.latitude,
		st.longitude,
		st.hydrologic_unit_code,
		st.sgo_indicator
	from fa_station st
	where st.organization_id = re.organization_id
	and st.station_is_number = re.tsmstatn_is_number
	and st.location_point_type = '*POINT OF RECORD');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2_1.log
--RESULT UOM
UPDATE FA_REGULAR_RESULT RE SET RESULT_UNIT =
	(SELECT RSLTUOM.SHORT_FORM_NAME
	FROM storet.TSRUOM RSLTUOM
	WHERE re.TSRUOM_IS_NUMBER = RSLTUOM.TSRUOM_IS_NUMBER
  	AND re.TSRUOM_ORG_ID = RSLTUOM.TSRUOM_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_2.log
--activity attributes
update FA_REGULAR_RESULT RE
set (LOCATION_POINT_TYPE    ,
POINT_SEQUENCE_NUMBER  ,
WELL_NUMBER            ,
PIPE_NUMBER            ,
ACTIVITY_LATITUDE      ,
ACTIVITY_LONGITUDE     ,
FK_ACT_MAD_HDATUM      ,
FK_ACT_MAD_HMETHOD     ,
activity_isn		,
POINT_NAME			,
MAP_SCALE) =  
(select b.LOCATION_POINT_TYPE    ,
b.POINT_SEQUENCE_NUMBER  ,
b.WELL_NUMBER            ,
b.PIPE_NUMBER            ,
b.ACTIVITY_LATITUDE      ,
b.ACTIVITY_LONGITUDE     ,
b.FK_ACT_MAD_HDATUM      ,
b.FK_ACT_MAD_HMETHOD     ,
b.activity_isn		,
b.POINT_NAME			,
b.MAP_SCALE
from fdact_temp2 b
where re.activity_is_number = b.activity_is_number
and  re.organization_id = b.organization_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_2a.log
-- activity attributes for ACTIVITY CATEGORY='Composite-with Parents'
-- set to the station location
update FA_REGULAR_RESULT re 
set (re.location_point_type,
     re.point_sequence_number,
     re.point_name,
     re.activity_latitude,
     re.activity_longitude,
     re.map_scale,
     re.fk_act_mad_hdatum,
     re.fk_act_mad_hmethod) =
(select st.location_point_type,
     st.point_sequence_number,
     st.point_name,
     st.latitude,
     st.longitude,
     st.map_scale,
     st.fk_mad_hdatum,
     st.fk_mad_hmethod
 from fa_station st
 where st.organization_id = re.organization_id
 and st.station_is_number = re.tsmstatn_is_number
 and st.location_point_type = '*POINT OF RECORD')
where re.activity_category = 'Composite-with Parents';
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_3.log
--ANALYTICAL PROCEDURE
UPDATE FA_REGULAR_RESULT RE SET (ANALYTICAL_PROCEDURE_SOURCE,ANALYTICAL_PROCEDURE_ID) =
	(SELECT ANLPR.SOURCE_ACR,
		ANLPR.PROCEDURE_ID	
	FROM storet1.TSRANLPR ANLPR
	WHERE re.TSRANLPR_IS_NUMBER = ANLPR.TSRANLPR_IS_NUMBER
	AND re.TSRANLPR_ORG_ID = ANLPR.TSRANLPR_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;
/**
--SAMPLE PREP
UPDATE FA_REGULAR_RESULT RE SET (SAMPLE_PREP_SOURCE,SAMPLE_PREP_NAME) =
	(SELECT LSPP.SOURCE_ACR,
		LSPP.NAME
	FROM storet1.TSRLSPP LSPP
	WHERE re.TSRLSPP_IS_NUMBER = LSPP.TSRLSPP_IS_NUMBER
	AND re.TSRLSPP_ORG_ID = LSPP.TSRLSPP_ORG_ID);
commit;
**/

--LAB
spool fa_reg_data2a_4.log
UPDATE FA_REGULAR_RESULT RE SET (LAB_ID,LAB_NAME) =
	(SELECT LAB.ID_CODE,
		LAB.NAME
	FROM storet1.TSRLAB LAB
	WHERE re.TSRLAB_IS_NUMBER = LAB.TSRLAB_IS_NUMBER
	AND re.ORGANIZATION_ID= LAB.TSRLAB_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_5.log
--QUANT LIMITS
UPDATE FA_REGULAR_RESULT RE SET (LOWER_QUANTITATION_LIMIT,UPPER_QUANTITATION_LIMIT,DETECTION_LIMIT,
 	DETECTION_LIMIT_DESCRIPTION) =
 	(SELECT DQL.MIN_QUANT_LIMIT,
  		DQL.MAX_QUANT_LIMIT,
  		DQL.MIN_DETECT_LIMIT||' '||UOM.SHORT_FORM_NAME,
  		DQL.DESCRIPTION_TEXT
 	FROM storet1.TSRDQL DQL, storet.TSRUOM UOM
 	WHERE re.RESULT_IS_NUMBER = DQL.TSRRSULT_IS_NUMBER
 		AND re.ORGANIZATION_ID = DQL.TSRRSULT_ORG_ID
 		AND DQL.TSRUOM_IS_NUMBER = UOM.TSRUOM_IS_NUMBER
 		AND DQL.TSRUOM_ORG_ID = UOM.TSRUOM_ORG_ID);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_6.log
--FK_DATE
update FA_REGULAR_RESULT re set fk_date_act_start = (
	select da.pk_isn from di_date da
	where TO_CHAR(re.activity_start_date_time,'DD-MON-YYYY') = da.full_date);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_7.log
--** new Activity Elements section **
--FIELD PROCEDURE
update FA_REGULAR_RESULT re
set (field_procedure_id) = (
	select id_code
	from storet1.TSRFLDPR fldpr
	where re.tsrfldpr_is_number = fldpr.tsrfldpr_is_number
	and re.ORGANIZATION_ID = fldpr.tsrfldpr_org_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;
/**
--SAMPLE
update FA_REGULAR_RESULT re
set (container_type,container_color,temperature_presrvtn_type,presrvtn_storage_procedure) = (
	select container_type_nm,container_color,temp_preservn_type,presrv_strge_prcdr
	from storet1.tsrsmple smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;
**/

spool fa_reg_data2a_8.log
--GEAR CONFIG
update FA_REGULAR_RESULT re
set (gear_config_id) = (
	select id_code
	from storet1.tsrgrcfg grcfg
	where re.tsrgrcfg_is_number = grcfg.tsrgrcfg_is_number
	and re.ORGANIZATION_ID = grcfg.tsrgrcfg_org_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_9.log
--FIELD GEAR ID
update FA_REGULAR_RESULT re
set (field_gear_id) = (
	select id_code
	from storet.tsrfldgr fldgr
	where re.tsrfldgr_is_number = fldgr.tsrfldgr_is_number);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_10.log
--ACTIVITY MATRIX
update FA_REGULAR_RESULT re
set (re.activity_matrix) = (
	select matrx.name
	from storet.tsrmatrx matrx
	where re.tsrmatrx_is_number = matrx.tsrmatrx_is_number);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_11.log
--GNTXT FIELDS
update FA_REGULAR_RESULT re
set (re.result_comment) = (
	select long_text
	from long_temp lt
	where lt.organization_id = re.organization_id
		AND lt.result_is_number = re.result_is_number
		AND lt.long_type ='RSLTCMNT');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_12.log
update FA_REGULAR_RESULT re
set (re.text_result) = (
	select long_text
	from long_temp lt
	where lt.organization_id = re.organization_id
		AND lt.result_is_number = re.result_is_number
		AND lt.long_type ='DESCRIPT');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_13.log
-- Lab Remarks
update FA_REGULAR_RESULT a
set a.LAB_REMARK= (select b.lbrmk from lbrmk_temp b
       where b.tsrrsult_is_number = a.result_is_number
           and b.tsrrsult_org_id = a.organization_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_14.log
-- FIELD SET
update FA_REGULAR_RESULT a
set a.field_set= (select b.field_set from fieldset_temp b
       where a.activity_is_number = b.activity_is_number
	and a.organization_id = b.organization_id);
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

-- NEW v2.0 SAMPLE_FRACTION_TYPES
update FA_REGULAR_RESULT re
set (SAMPLE_FRACTION_TYPE) = (
     select FIELD_VALUE
     from storet.TSMPRMVL b
     where b.tsmprmvl_is_number = re.tsmprmvl_is_number 
           and b.field_name = 'SMPL_FRAC_TYPE_NM'
           and b.table_name = 'TSRRSULT')
WHERE re.TSMPRMVL_IS_NUMBER IS NOT NULL;
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_15.log
--CHARACTERISTIC ALIASES
update FA_REGULAR_RESULT re
set ITIS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'ITIS TAXON SERIAL NUMBER');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

update FA_REGULAR_RESULT re
set CAS_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'CAS NUMBER');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;
spool off;

spool fa_reg_data2a_16.log
--EPA registry num
update FA_REGULAR_RESULT re
set EPA_REG_NUMBER = (
     select NAME 
     from storet.TSRCHALS als 
     where re.fk_char = als.tsrchar_is_number
       and als.type_name = 'EPA ID (SUBSTANCE REGISTRY)');
commit;
SET TRANSACTION USE ROLLBACK SEGMENT rbsbig;

--SAMPLE PRES ELEMENTS
update FA_REGULAR_RESULT re
set (container_desc,TEMP_PRESERVN_TYPE,presrv_strge_prcdr) = (
	select container_desc,TEMP_PRESERVN_TYPE,presrv_strge_prcdr
	from sample_pres_temp smple
	where re.activity_is_number = smple.tsrfdact_is_number
	and re.organization_id = smple.tsrfdact_org_id);
commit;

spool off